<?php
namespace Database\Seeders\Access;

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

/**
 * Class PermissionTableSeeder
 */
class PermissionTableSeeder extends Seeder
{
    /**
     * Run the database seed.
     *
     * @return void
     */
    public function run()
    {
        if (DB::connection()->getDriverName() == 'mysql') {
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        }

        if (DB::connection()->getDriverName() == 'mysql') {
            DB::table(config('access.permissions_table'))->truncate();
            DB::table(config('access.permission_role_table'))->truncate();
        } elseif (DB::connection()->getDriverName() == 'sqlite') {
            DB::statement('DELETE FROM ' . config('access.permissions_table'));
            DB::statement('DELETE FROM ' . config('access.permission_role_table'));
        } else {
            //For PostgreSQL or anything else
            DB::statement('TRUNCATE TABLE ' . config('access.permissions_table') . ' CASCADE');
            DB::statement('TRUNCATE TABLE ' . config('access.permission_role_table') . ' CASCADE');
        }

        /**
         * Don't need to assign any permissions to administrator because the all flag is set to true
         * in RoleTableSeeder.php
         */

        /**
         * Misc Access Permissions
         */
        $permission_model          = config('access.permission');
        $viewBackend               = new $permission_model;
        $viewBackend->name         = 'view-backend';
        $viewBackend->display_name = 'View Backend';
        $viewBackend->sort         = 1;
        $viewBackend->created_at   = Carbon::now();
        $viewBackend->updated_at   = Carbon::now();
        $viewBackend->save();

        /**
         * Access Permissions
         */
        $permission_model          = config('access.permission');
        $manageUsers               = new $permission_model;
        $manageUsers->name         = 'manage-users';
        $manageUsers->display_name = 'Manage Users';
        $manageUsers->sort         = 2;
        $manageUsers->created_at   = Carbon::now();
        $manageUsers->updated_at   = Carbon::now();
        $manageUsers->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'manage-roles';
        $manageRoles->display_name = 'Manage Roles';
        $manageRoles->sort         = 3;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'manage-blogs';
        $manageRoles->display_name = 'Manage Blogs';
        $manageRoles->sort         = 4;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'edit-blogs';
        $manageRoles->display_name = 'Edit Blogs';
        $manageRoles->sort         = 5;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'delete-blogs';
        $manageRoles->display_name = 'Delete Blogs';
        $manageRoles->sort         = 6;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'manage-categories';
        $manageRoles->display_name = 'Manage Categories';
        $manageRoles->sort         = 7;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'edit-categories';
        $manageRoles->display_name = 'Edit Categories';
        $manageRoles->sort         = 8;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'delete-categories';
        $manageRoles->display_name = 'Delete Categories';
        $manageRoles->sort         = 9;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'manage-pages';
        $manageRoles->display_name = 'Manage Pages';
        $manageRoles->sort         = 10;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'edit-pages';
        $manageRoles->display_name = 'Edit Pages';
        $manageRoles->sort         = 11;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'delete-pages';
        $manageRoles->display_name = 'Delete Pages';
        $manageRoles->sort         = 12;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'manage-menu';
        $manageRoles->display_name = 'Manage Menu';
        $manageRoles->sort         = 13;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'manage-theme-options';
        $manageRoles->display_name = 'Manage Theme Options';
        $manageRoles->sort         = 14;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'manage-settings';
        $manageRoles->display_name = 'Manage Settings';
        $manageRoles->sort         = 15;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'manage-media';
        $manageRoles->display_name = 'Manage Media';
        $manageRoles->sort         = 16;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'manage-gallery';
        $manageRoles->display_name = 'Manage Gallery';
        $manageRoles->sort         = 17;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'manage-comments';
        $manageRoles->display_name = 'Manage Comment';
        $manageRoles->sort         = 18;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();


        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'manage-custom-post-type';
        $manageRoles->display_name = 'Manage Custom Post Type';
        $manageRoles->sort         = 19;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        $permission_model          = config('access.permission');
        $manageRoles               = new $permission_model;
        $manageRoles->name         = 'manage-appearance';
        $manageRoles->display_name = 'Manage Appearance';
        $manageRoles->sort         = 20;
        $manageRoles->created_at   = Carbon::now();
        $manageRoles->updated_at   = Carbon::now();
        $manageRoles->save();

        if (DB::connection()->getDriverName() == 'mysql') {
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        }
    }
}