<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMenuitemTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
         Schema::create('menuitem_translations', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('menu_item_id');
            $table->string('locale', 2);
            $table->string('title');

            $table->foreign('menu_item_id')
                ->references('id')
                ->on('menuitems')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('menuitem_translations');
    }
}
