<?php

return [
    [
        'key' => 'dashboard',
        'name' => 'Dashboard',
        'route' => 'admin.dashboard',
        'sort' => 1,
        'icon-class' => 'fas fa-th',
        'permission' => 'view-backend'
    ],
    [
        'key' => 'access',
        'name' => 'Users',
        'route' => 'admin.access.user.index',
        'sort' => 2,
        'icon-class' => 'fas fa-users',
        'permission' => 'manage-users'
    ],
    [
        'key' => 'access.users',
        'name' => 'All Users',
        'route' => 'admin.access.user.index',
        'routes' => ['admin.access.user.index'],
        'permission' => 'manage-users',
        'sort' => 1,
    ],
    [
        'key' => 'access.roles',
        'name' => 'All Roles',
        'route' => 'admin.access.role.index',
        'routes' => ['admin.access.role.index'],
        'permission' => 'manage-users',
        'sort' => 2,
    ],
    [
        'key' => 'posts',
        'name' => 'Posts',
        'route' => 'admin.blog.index',
        'sort' => 3,
        'icon-class' => 'fas fa-file',
        'permission' => 'manage-blogs'
    ],
    [
        'key' => 'posts.all',
        'name' => 'All Posts',
        'route' => 'admin.blog.index',
        'routes' => ['admin.blog.index', 'admin.blog.edit'],
        'sort' => 1,
        'icon-class' => 'far fa-circle',
        'permission' => 'manage-blogs'
    ],
    [
        'key' => 'posts.create',
        'name' => 'Create Post',
        'route' => 'admin.blog.create',
        'routes' => ['admin.blog.create'],
        'sort' => 2,
        'icon-class' => 'far fa-circle',
        'permission' => 'edit-blogs'
    ],
    [
        'key' => 'posts.category',
        'name' => 'Category',
        'route' => 'admin.category.create',
        'routes' => ['admin.category.create'],
        'sort' => 3,
        'icon-class' => 'far fa-circle',
        'permission' => 'manage-categories'
    ],
    [
        'key' => 'page',
        'name' => 'Page',
        'route' => 'admin.page.index',
        'sort' => 4,
        'icon-class' => 'fas fa-file-alt',
        'permission' => 'manage-pages'
    ],
    [
        'key' => 'page.all',
        'name' => 'All Pages',
        'route' => 'admin.page.index',
        'routes' => ['admin.page.index', 'admin.page.edit'],
        'sort' => 1,
        'icon-class' => 'far fa-circle',
        'permission' => 'manage-pages'
    ],
    [
        'key' => 'page.create',
        'name' => 'Create Page',
        'route' => 'admin.page.create',
        'routes' => ['admin.page.create'],
        'sort' => 2,
        'icon-class' => 'far fa-circle',
        'permission' => 'edit-pages'
    ],
    [
        'key' => 'media',
        'name' => 'Media',
        'route' => 'admin.media.index',
        'sort' => 6,
        'icon-class' => 'fas fa-camera',
        'permission' => 'manage-media'
    ],
    [
        'key' => 'appearance',
        'name' => 'Appearance',
        'route' => 'admin.themes.index',
        'sort' => 7,
        'icon-class' => 'fas fa-desktop',
        'permission' => 'manage-appearance'
    ],
    [
        'key' => 'appearance.theme',
        'name' => 'Theme',
        'route' => 'admin.themes.index',
        'routes' => ['admin.themes.index'],
        'sort' => 1,
        'icon-class' => 'far fa-circle',
        'permission' => 'manage-theme'
    ],
    [
        'key' => 'appearance.menu',
        'name' => 'Menu',
        'route' => 'admin.menu.index',
        'routes' => ['admin.menu.index'],
        'sort' => 2,
        'icon-class' => 'far fa-circle',
        'permission' => 'manage-menu'
    ],
    [
        'key' => 'appearance.custom_css',
        'name' => 'Custom CSS',
        'route' => 'admin.setting.custom_css',
        'routes' => ['admin.setting.custom_css'],
        'sort' => 3,
        'icon-class' => 'far fa-circle',
        'permission' => 'manage-custom-css'
    ],
    [
        'key' => 'appearance.themeeditor',
        'name' => 'Theme Editor',
        'route' => 'admin.theme.editor',
        'routes' => ['admin.theme.editor'],
        'sort' => 4,
        'icon-class' => 'far fa-circle',
        'permission' => 'manage-theme'
    ],
    [
        'key' => 'gallery',
        'name' => 'Gallery',
        'route' => 'admin.gallery.index',
        'sort' => 10,
        'icon-class' => 'fas fa-images',
        'permission' => 'manage-gallery'
    ],
    [
        'key' => 'settings',
        'name' => 'Settings',
        'route' => 'admin.setting.general',
        'sort' => 11,
        'icon-class' => 'fas fa-cog',
        'permission' => 'manage-settings'
    ],
    [
        'key' => 'settings.general',
        'name' => 'General',
        'route' => 'admin.setting.general',
        'routes' => ['admin.settings.general'],
        'sort' => 1,
        'icon-class' => 'far fa-circle',
        'permission' => 'manage-settings'
    ],
    [
        'key' => 'settings.seo',
        'name' => 'SEO',
        'route' => 'admin.setting.seo',
        'routes' => ['admin.settings.seo'],
        'sort' => 2,
        'icon-class' => 'far fa-circle',
        'permission' => 'manage-settings'
    ],
    [
        'key' => 'settings.miscellaneous',
        'name' => 'Miscellaneous',
        'route' => 'admin.setting.miscellaneous',
        'routes' => ['admin.setting.miscellaneous'],
        'sort' => 2,
        'icon-class' => 'far fa-circle',
        'permission' => 'manage-settings'
    ],
];
