<?php

use App\Helpers\Settings;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\HtmlString;
use Illuminate\Support\Str;
use Rawbinn\Larapress\Facades\Larapress;
use Rawbinn\Larapress\HashedCallable;
use Rawbinn\Themes\Facades\Theme;

/*
 * Global helpers file with misc functions
 */

if (!function_exists('app_name')) {
    /**
     * Helper to grab the application name.
     *
     * @return mixed
     */
    function app_name()
    {
        return config('app.name');
    }
}

if (!function_exists('access')) {
    /**
     * Access (lol) the Access:: facade as a simple function.
     */
    function access()
    {
        return app('access');
    }
}

if (!function_exists('history')) {
    /**
     * Access the history facade anywhere.
     */
    function history()
    {
        return app('history');
    }
}

if (!function_exists('getFallbackLocale')) {
    /**
     * Get the fallback locale.
     *
     * @return \Illuminate\Foundation\Application|mixed
     */
    function getFallbackLocale()
    {
        return config('app.fallback_locale');
    }
}

if (!function_exists('getLanguageBlock')) {
    /**
     * Get the language block with a fallback.
     *
     * @param $view
     * @param array $data
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    function getLanguageBlock($view, $data = [])
    {
        $components = explode('lang', $view);
        $current = $components[0].'lang.'.app()->getLocale().'.'.$components[1];
        $fallback = $components[0].'lang.'.getFallbackLocale().'.'.$components[1];

        if (view()->exists($current)) {
            return view($current, $data);
        } else {
            return view($fallback, $data);
        }
    }
}

if (!function_exists('includeRouteFiles')) {
    /**
     * Loops through a folder and requires all PHP files
     * Searches sub-directories as well.
     *
     * @param $folder
     */
    function includeRouteFiles($folder)
    {
        $directory = $folder;
        $handle = opendir($directory);
        $directory_list = [$directory];

        while (false !== ($filename = readdir($handle))) {
            if ($filename != '.' && $filename != '..' && is_dir($directory.$filename)) {
                array_push($directory_list, $directory.$filename.'/');
            }
        }

        foreach ($directory_list as $directory) {
            foreach (glob($directory.'*.php') as $filename) {
                require $filename;
                // echo $filename.'<br>';
            }
        }
    }
}

if (!function_exists(('uniqueName'))) {
    /**
     * Returns unique name concating current data, unique id and current time in unix.
     */
    function uniqueName()
    {
        return date('Y-m-d', time()).'_'.uniqid().'_'.time();
    }
}

if (!function_exists(('excerpt'))) {
    /**
     * Returns limited words from large post.
     */
    function excerpt($string, $count = 20, $readmore = false, $end = null, $strip_tags = true)
    {
        $original_string = $string;
        if ($strip_tags) {
            $string = strip_tags($string);
            if (preg_match_all('/{{(.*?)}}/', $string, $matches)) {
                foreach ($matches[0] as $match) {
                    $string = str_replace($match, '', $string);
                }
            }
        }

        $words = explode(' ', $string);
        $words_gt_count = count($words) > $count;
        if ($words_gt_count) {
            $words = array_slice($words, 0, $count);
            $string = implode(' ', $words);
        }

        if ($end != null && $words_gt_count) {
            $string = $string.strip_tags($end);
        }

        if ($readmore && $words_gt_count) {
            return $string.' <a class="btn btn-primary" href="'.$readmore.'">Read More &rarr;</a>';
        }

        return Shortcode::strip($string);
    }
}

if (!function_exists(('getGallery'))) {
    function getGallery($slug = null)
    {
        if ($slug != null) {
            $gallery = App\Models\Gallery\Gallery::where('slug', $slug)->first();
        } else {
            $gallery = App\Models\Gallery\Gallery::get();
        }
        if ($gallery != null) {
            return $gallery;
        }

        return false;
    }
}

if (!function_exists('post')) {
    function post($slug)
    {
        return Larapress::post($slug);
    }
}

if (!function_exists('posts')) {
    function posts($pagination = 10, $attributes = [])
    {
        return Larapress::posts($pagination, $attributes);
    }
}

if (!function_exists('categories')) {
    function categories($display = 'default')
    {
        return Larapress::categories($display);
    }
}

/**
 * @deprecated
 */
if (!function_exists('getPostBySlug')) {
    function getPostBySlug($slug)
    {
        return Larapress::getPostBySlug($slug);
    }
}

if (!function_exists('do_shortcode')) {
    function do_shortcode($shortcode)
    {
        return Shortcode::compile($shortcode);
    }
}

if (!function_exists('home_route')) {
    /**
     * Return the route to the "home" page depending on authentication/authorization status.
     *
     * @return string
     */
    function home_route()
    {
        if (auth()->check()) {
            if (access()->allow('view-backend')) {
                return 'admin.dashboard';
            } else {
                return 'user.dashboard';
            }
        }

        return 'index';
    }
}

if (!function_exists('support_me')) {
    function support_me()
    {
        return 'Powered by <a href="https://larapress.seshra.com.np" target="_blan">Larapress</a>';
    }
}

if (!function_exists('has_new_version')) {
    function has_new_version()
    {
        dd(config('app.version'));
    }
}

if (!function_exists('theme_image')) {
    function theme_image($filename)
    {
    }
}

if (!function_exists(('image'))) {
    function image($id, $thumbnail = false)
    {
        $image = \DB::table(config("media.table"))->where('id', $id)->first();
        if ($image != null) {
            if ($thumbnail) {
                return substr_replace($image->path, 'thumbs/', strpos($image->path, $image->image), 0);
            }

            return str_replace('\\', '/', public_asset('storage/'.$image->path));
        }

        return '';
    }
}

if (!function_exists('str_singular')) {
    /**
     * Get the singular form of an English word.
     *
     * @param string $value
     *
     * @return string
     */
    function str_singular($value)
    {
        return Str::singular($value);
    }
}

if (!function_exists(('month'))) {
    function month($month)
    {
        switch ($month) {
            case 1:
                return 'January';
                break;
            case 2:
                return 'February';
                break;
            case 3:
                return 'March';
                break;
            case 4:
                return 'April';
                break;
            case 5:
                return 'May';
                break;
            case 6:
                return 'June';
                break;
            case 7:
                return 'July';
                break;
            case 8:
                return 'August';
                break;
            case 9:
                return 'September';
                break;
            case 10:
                return 'October';
                break;
            case 11:
                return 'November';
                break;
            case 12:
                return 'December';
                break;
            default:
                return 'Undefined';
                break;
        }
    }
}

if (!function_exists(('dynamic_admin_class'))) {
    function dynamic_admin_class()
    {
        $current_url = url()->current();
        $str = substr($current_url, strpos($current_url, 'admin') + 6);

        return 'larapress-'.str_replace('/', '-', $str);
    }
}

if (!function_exists(('script'))) {
    function script($path)
    {
        return new HtmlString('<script src="'.public_asset($path).'"></script>');
    }
}

if (!function_exists(('style'))) {
    function style($path)
    {
        return new HtmlString('<link rel="stylesheet" href="'.public_asset($path).'">');
    }
}

if (!function_exists(('public_asset'))) {
    function public_asset($path)
    {
        // if (strpos(asset($path), 'public') !== false) {
            return asset($path);
        // }
        // return asset('public/'.$path);
    }
}

if (!function_exists('are_active_routes')) {
    function are_active_routes($routes, $output = 'active')
    {
        if (is_array($routes)) {
            foreach ($routes as $route) {
                if (Route::currentRouteName() == $route) {
                    return $output;
                }
            }
        } else {
            if (Route::currentRouteName() == $routes) {
                return $output;
            }
        }
    }
}

if (!function_exists('settings')) {
    function settings($key, $default = null)
    {
        return Settings::get($key, $default);
    }
}

if (!function_exists('array_keys_exists')) {
    function array_keys_exists(array $keys, array $arr)
    {
        return !array_diff_key(array_flip($keys), $arr);
    }
}

if (!function_exists('nav_menu')) {
    function nav_menu($location, $menu)
    {
        
        $theme_menu = setting('theme-active', config('themes.active')).'-menu';
        return Larapress::getMenu($location, settings($theme_menu.'.'.$menu));
    }
}

if (!function_exists('custom_css')) {
    function custom_css()
    {
        $theme_name = setting('theme-active', config('themes.active')).'-customcss';
        return strip_tags(setting($theme_name));
    }
}

if (!function_exists('site_logo')) {
    function site_logo($default = 'default')
    {
        if($default == 'dark') {
            return image(setting('site-logo-dark'));
        }
        return setting('site-logo', false) ? image(setting('site-logo')) : public_asset('images/larapress/logo_small.png');
    }
}

if (!function_exists('site_favicon')) {
    function site_favicon()
    {
        return setting('favicon', false) ? image(setting('favicon')) : public_asset('images/favicon/favicon.ico');
    }
}

if (!function_exists('register_nav_menus')) {
    function register_nav_menus(array $menuLocations)
    {
        Eventy::addFilter('regsiter_nav_menus', function() use ($menuLocations) {
            return $menuLocations;
        });
    }
}

if (!function_exists('register_page_templates')) {
    function register_page_templates(array $templates)
    {
        Eventy::addFilter('regsiter_page_templates', function() use ($templates) {
            return $templates;
        });
    }
}

if (!function_exists('add_action')) {
    function add_action($name, $closure, $priority = 20, $accepted_arguments = 1)
    {
        Eventy::addAction($name, $closure, $priority, $accepted_arguments);
    }
}

if (!function_exists('register_options')) {
    function register_options(array $options)
    {
        Eventy::addFilter('register_options', function() use ($options) {
            return $options;
        });
    }
}

if (!function_exists('register_post_type')) {
    function register_post_type($type , $callback){
        global $post_types;
        if($callback instanceof \Closure) {
            $args = call_user_func_array($callback, $arguments = []);
        }
        elseif (is_callable($callback)) {
            $args = $callback();
        } elseif (is_array($callback)) {
            $args = $callback;
        } else {
            throw new \Exception('$callback is not a Callable', 1);
        }
        $post_types[Str::slug(strtolower($type))] = $args;
    }
}

if (!function_exists('get_post_types')) {
    function get_post_types()
    {
        global $post_types;
        return $post_types ?? [];
    }
}

if (!function_exists('generate_key')) {
    function generate_key($key, $flag)
    {
       return Larapress::generateKey($key, $flag);
    }
}

if (!function_exists('scan_all')) {
function scan_all($dir) {
    $result = [];
    foreach(scandir($dir) as $filename) {
      if ($filename[0] === '.') continue;
      $filePath = $dir . '/' . $filename;
      if (is_dir($filePath)) {
        foreach (scan_all($filePath) as $childFilename) {
          $result[] = $filename . '/' . $childFilename;
        }
      } else {
        $result[] = $filename;
      }
    }
    return $result;
  }
}


/**
 * Escaping for HTML blocks.
 *
 * @since 2.8.0
 *
 * @param string $text
 * @return string
 */
if (!function_exists('esc_html')) {
function esc_html( $text ) {
	$safe_text = wp_check_invalid_utf8( $text );
	$safe_text = _wp_specialchars( $safe_text, ENT_QUOTES );
	/**
	 * Filters a string cleaned and escaped for output in HTML.
	 *
	 * Text passed to esc_html() is stripped of invalid or special characters
	 * before output.
	 *
	 * @since 2.8.0
	 *
	 * @param string $safe_text The text after it has been escaped.
	 * @param string $text      The text prior to being escaped.
	 */
	return $safe_text;
}
}

/**
 * Escaping for HTML attributes.
 *
 * @since 2.8.0
 *
 * @param string $text
 * @return string
 */
if (!function_exists('esc_attr')) {
function esc_attr( $text ) {
	$safe_text = wp_check_invalid_utf8( $text );
	$safe_text = _wp_specialchars( $safe_text, ENT_QUOTES );
	/**
	 * Filters a string cleaned and escaped for output in an HTML attribute.
	 *
	 * Text passed to esc_attr() is stripped of invalid or special characters
	 * before output.
	 *
	 * @since 2.0.6
	 *
	 * @param string $safe_text The text after it has been escaped.
	 * @param string $text      The text prior to being escaped.
	 */
	return $safe_text;
}
}

/**
 * Escaping for textarea values.
 *
 * @since 3.1.0
 *
 * @param string $text
 * @return string
 */
if (!function_exists('esc_textarea')) {
function esc_textarea( $text ) {
	$safe_text = htmlspecialchars( $text, ENT_QUOTES, 'UTF-8' );
	/**
	 * Filters a string cleaned and escaped for output in a textarea element.
	 *
	 * @since 3.1.0
	 *
	 * @param string $safe_text The text after it has been escaped.
	 * @param string $text      The text prior to being escaped.
	 */
	return $safe_text;
}
}

/**
 * Checks for invalid UTF8 in a string.
 *
 * @since 2.8.0
 *
 * @param string $string The text which is to be checked.
 * @param bool   $strip  Optional. Whether to attempt to strip out invalid UTF8. Default false.
 * @return string The checked text.
 */
if (!function_exists('wp_check_invalid_utf8')) {
function wp_check_invalid_utf8( $string, $strip = false ) {
	$string = (string) $string;

	if ( 0 === strlen( $string ) ) {
		return '';
	}

	// Store the site charset as a static to avoid multiple calls to get_option().
	static $is_utf8 = null;
	if ( ! isset( $is_utf8 ) ) {
		$is_utf8 = in_array( 'UTF-8', array( 'utf8', 'utf-8', 'UTF8', 'UTF-8' ), true );
	}
	if ( ! $is_utf8 ) {
		return $string;
	}

	// Check for support for utf8 in the installed PCRE library once and store the result in a static.
	static $utf8_pcre = null;
	if ( ! isset( $utf8_pcre ) ) {
		// phpcs:ignore WordPress.PHP.NoSilencedErrors.Discouraged
		$utf8_pcre = @preg_match( '/^./u', 'a' );
	}
	// We can't demand utf8 in the PCRE installation, so just return the string in those cases.
	if ( ! $utf8_pcre ) {
		return $string;
	}

	// phpcs:ignore WordPress.PHP.NoSilencedErrors.Discouraged -- preg_match fails when it encounters invalid UTF8 in $string.
	if ( 1 === @preg_match( '/^./us', $string ) ) {
		return $string;
	}

	// Attempt to strip the bad chars if requested (not recommended).
	if ( $strip && function_exists( 'iconv' ) ) {
		return iconv( 'utf-8', 'utf-8', $string );
	}

	return '';
}
}

/**
 * Converts a number of special characters into their HTML entities.
 *
 * Specifically deals with: &, <, >, ", and '.
 *
 * $quote_style can be set to ENT_COMPAT to encode " to
 * &quot;, or ENT_QUOTES to do both. Default is ENT_NOQUOTES where no quotes are encoded.
 *
 * @since 1.2.2
 * @since 5.5.0 `$quote_style` also accepts `ENT_XML1`.
 * @access private
 *
 * @param string       $string        The text which is to be encoded.
 * @param int|string   $quote_style   Optional. Converts double quotes if set to ENT_COMPAT,
 *                                    both single and double if set to ENT_QUOTES or none if set to ENT_NOQUOTES.
 *                                    Converts single and double quotes, as well as converting HTML
 *                                    named entities (that are not also XML named entities) to their
 *                                    code points if set to ENT_XML1. Also compatible with old values;
 *                                    converting single quotes if set to 'single',
 *                                    double if set to 'double' or both if otherwise set.
 *                                    Default is ENT_NOQUOTES.
 * @param false|string $charset       Optional. The character encoding of the string. Default false.
 * @param bool         $double_encode Optional. Whether to encode existing HTML entities. Default false.
 * @return string The encoded text with HTML entities.
 */
if (!function_exists('_wp_specialchars')) {
function _wp_specialchars( $string, $quote_style = ENT_NOQUOTES, $charset = false, $double_encode = false ) {
	$string = (string) $string;

	if ( 0 === strlen( $string ) ) {
		return '';
	}

	// Don't bother if there are no specialchars - saves some processing.
	if ( ! preg_match( '/[&<>"\']/', $string ) ) {
		return $string;
	}

	// Account for the previous behaviour of the function when the $quote_style is not an accepted value.
	if ( empty( $quote_style ) ) {
		$quote_style = ENT_NOQUOTES;
	} elseif ( ENT_XML1 === $quote_style ) {
		$quote_style = ENT_QUOTES | ENT_XML1;
	} elseif ( ! in_array( $quote_style, array( ENT_NOQUOTES, ENT_COMPAT, ENT_QUOTES, 'single', 'double' ), true ) ) {
		$quote_style = ENT_QUOTES;
	}

	// Store the site charset as a static to avoid multiple calls to wp_load_alloptions().
	if ( ! $charset ) {
		$charset = 'UTF-8';
	}

	if ( in_array( $charset, array( 'utf8', 'utf-8', 'UTF8' ), true ) ) {
		$charset = 'UTF-8';
	}

	$_quote_style = $quote_style;

	if ( 'double' === $quote_style ) {
		$quote_style  = ENT_COMPAT;
		$_quote_style = ENT_COMPAT;
	} elseif ( 'single' === $quote_style ) {
		$quote_style = ENT_NOQUOTES;
	}

	if ( ! $double_encode ) {
		// Guarantee every &entity; is valid, convert &garbage; into &amp;garbage;
		// This is required for PHP < 5.4.0 because ENT_HTML401 flag is unavailable.
		$string = wp_kses_normalize_entities( $string, ( $quote_style & ENT_XML1 ) ? 'xml' : 'html' );
	}

	$string = htmlspecialchars( $string, $quote_style, $charset, $double_encode );

	// Back-compat.
	if ( 'single' === $_quote_style ) {
		$string = str_replace( "'", '&#039;', $string );
	}

	return $string;
}
}
/**
 * Converts and fixes HTML entities.
 *
 * This function normalizes HTML entities. It will convert `AT&T` to the correct
 * `AT&amp;T`, `&#00058;` to `&#058;`, `&#XYZZY;` to `&amp;#XYZZY;` and so on.
 *
 * When `$context` is set to 'xml', HTML entities are converted to their code points.  For
 * example, `AT&T&hellip;&#XYZZY;` is converted to `AT&amp;T…&amp;#XYZZY;`.
 *
 * @since 1.0.0
 * @since 5.5.0 Added `$context` parameter.
 *
 * @param string $string  Content to normalize entities.
 * @param string $context Context for normalization. Can be either 'html' or 'xml'.
 *                        Default 'html'.
 * @return string Content with normalized entities.
 */
if (!function_exists('wp_kses_normalize_entities')) {
function wp_kses_normalize_entities( $string, $context = 'html' ) {
	// Disarm all entities by converting & to &amp;
	$string = str_replace( '&', '&amp;', $string );

	return $string;
}
}
if ( ! function_exists( 'of_get_option' ) ) {
    function of_get_option( $name, $default = false ) {
    
        $option_name = '';
    
       $option_name = Larapress::option_framework_name();

        // Get option settings from database
        $lang = Lang::locale();
        if($lang != 'en') {
            $options = settings($option_name.'_'.$lang, settings($option_name));
        }else {
            $options = settings( $option_name );
        }
        // Return specific option
        if ( isset( $options[$name] ) ) {
            return $options[$name];
        }
    
        return $default;
    }
}

if ( ! function_exists( 'get_option' ) ) {
    function get_option( $name, $default = false ) {
    
        $option_name = '';
    
       $option_name = Larapress::option_framework_name();

        // Get option settings from database
        $lang = Lang::locale();
        if($lang != 'en') {
            $options = settings($option_name.'_'.$lang, settings($option_name));
        }else {
            $options = settings( $option_name );
        }
        // Return specific option
        if ( isset( $options[$name] ) ) {
            return $options[$name];
        }
    
        return $default;
    }
}

if ( ! function_exists( 'locales' ) ) {
    function locales() {
        return config('translatable.locales');
    }
}

if (!function_exists('lang')) {
    function lang($lang)
    {
        return ($lang != '') ? $lang : config('app.fallback_locale');
    }
}

if (!function_exists('default_lang')) {
    function default_lang()
    {
        $locales = locales();
        return  $locales[0] ?? config('app.fallback_locale');
    }
}

if (! function_exists(('estimate_reading_time')))
{
   function estimate_reading_time($content, $wpm = 200) {
		// $wordCount = str_word_count(strip_tags($content));
		$wordCount = count_unicode_words($content);
		$minutes = (int) floor($wordCount / $wpm);
		$seconds = (int) floor($wordCount % $wpm / ($wpm / 60));

		// $str_minutes = ($minutes === 1) ? 'min' : 'mins';
		// $str_seconds = ($seconds === 1) ? 'sec' : 'secs';

		if ($minutes === 0) {
			return "{$seconds} sec";
		}
		else {
			return "{$minutes} min";
			// return "{$minutes} {$str_minutes}, {$seconds} {$str_seconds}";
		}
	}
}

if (! function_exists(('count_unicode_words'))) {
// The function to count words in Unicode  strings
function count_unicode_words( $unicode_string ){
	// First remove all the punctuation marks & digits
	$unicode_string = preg_replace('/[[:punct:][:digit:]]/', '', $unicode_string);
	// Now replace all the whitespaces (tabs, new lines, multiple spaces) by single space
	$unicode_string = preg_replace('/[[:space:]]/', ' ', $unicode_string);
	// The words are now separated by single spaces and can be splitted to an array
	// I have included \n\r\t here as well, but only space will also suffice
	$words_array = preg_split( "/[\n\r\t ]+/", $unicode_string, 0, PREG_SPLIT_NO_EMPTY );
	// Now we can get the word count by counting array elments
	return count($words_array);
  }
}

if (! function_exists(('validateDate'))) {
    function validateDate($date, $format = 'Y-m-d H:i:s')
    {
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }
}