<?php

namespace App\Repositories;

/**
 * Class Repository
 * @package App\Repositories
 */
abstract class Repository extends BaseRepository
{
	/**
	 * @return mixed
	 */
	public function getAll($orderBy = 'ASC')
	{
		return $this->query()->orderBy('id', $orderBy)->get();
	}

	public function getPaginated($paginate = 5)
	{
		return $this->query()->paginate($paginate);
	}

	/**
	 * @return mixed
	 */
	public function getCount($trash = false) {
	    if($trash) {
	        return $this->query()->onlyTrashed()->count();
        }
		return $this->query()->count();
	}

	/**
	 * @param $id
	 * @return mixed
	 */
	public function find($id)
	{
		return $this->query()->find($id);
	}
}