<?php

namespace App\Repositories\Backend;

use Module;
use App\Services\Zipper;
use Rawbinn\Themes\Themes;
use App\Exceptions\GeneralException;
use Illuminate\Support\Facades\Storage;

/**
 * Class ThemeRepository
 * @package App\Repositories\Backend
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class ThemeRepository extends Themes
{
	
    public function getThemes()
	{
		return $this->all();
	}
	
	public function getThemeDetails()
	{
		$active_theme = setting('theme-active', config('themes.active'));
		$theme = Themes::getJsonContents($active_theme);
		$theme["slug"]= (array_key_exists('slug', $theme)) ? $theme['slug'] : '';
	    $theme["name"]= (array_key_exists('name', $theme)) ? $theme['name'] : '';
	    $theme["author"]= (array_key_exists('author', $theme)) ? $theme['author'] : '';
	    $theme["description"]= (array_key_exists('description', $theme))? $theme['description'] : '';
	    $theme["version"]= (array_key_exists('version', $theme)) ? $theme['version'] : '';
	    $theme["theme_url"]= (array_key_exists('theme_url', $theme)) ? $theme['theme_url'] : '';
	    $theme["author_url"]= (array_key_exists('author_url', $theme)) ? $theme['author_url'] : '';
		$theme['image'] = file_exists('public/themes/'.$active_theme.'/theme.jpg') ? public_asset('themes/'.$active_theme.'/theme.jpg') : public_asset('images/theme.jpg');
		$packages = false;
		// if(array_key_exists('packages', $function)){
		// 	foreach($function['packages'] as $package) {
		// 		if(Module::exists($package['slug'])) {
		// 			if(!Module::isEnabled($package['slug'])){
		// 				$packages[] = [
		// 					'title' => $package['title'],
		// 					'slug' => $package['slug'],
		// 					'status' => true
		// 				];
		// 			}
		// 		}
		// 		else{
		// 			$packages[] = [
		// 				'title' => $package['title'],
		// 				'slug' => $package['slug'],
		// 				'status' => false
		// 			];
		// 		}
		// 	}
		// }
		// $theme['packages'] = $packages;
		return $theme;

	}

	public function validateTheme($theme_name)
	{
		if(file_exists($this->getJsonPath($theme_name))) {			;
			if($this->getProperty($theme_name.'::name') == null) {
				throw new GeneralException('Invalid theme');
			}
			return true;
		}
		else{
			throw new GeneralException('Invalid theme');
		}
		
	}

	public function extract($path)
	{
		$theme_path = config('themes.paths.absolute');
		$zip = Zipper::open($path);
		$dir_name_inside_zip = rtrim($zip->getNameIndex(0), '/');
		$dir_name_inside_zip = explode('/', $dir_name_inside_zip);
		$dir_name_inside_zip = isset($dir_name_inside_zip[1]) ? $dir_name_inside_zip[0] : $dir_name_inside_zip;
		$full_theme_path = $theme_path.'/'.$dir_name_inside_zip;
		
		if(file_exists($full_theme_path)) {
			throw new GeneralException('Theme already exist with this name');
		}

		// dd($zip->listFiles());
		# Check if theme has theme.json,assets, views file or not
		if ($zip->locateName($dir_name_inside_zip . '/theme.json') !== false && $zip->locateName($dir_name_inside_zip . '/assets/')!==false && $zip->locateName($dir_name_inside_zip . '/views/')!==false) {
			
			$zip->extract($theme_path);
			$zip->close();
			$this->deleteAllFiles(storage_path('app'.DIRECTORY_SEPARATOR.'public'.DIRECTORY_SEPARATOR.'themes'));
			return true;
		} else {
			$this->deleteAllFiles(storage_path('app'.DIRECTORY_SEPARATOR.'public'.DIRECTORY_SEPARATOR.'themes'));
			return false;
		}

	}

	public function deleteAllFiles($folder)
	{
		//Get a list of all of the file names in the folder.
		$files = glob($folder . '/*');

		//Loop through the file list.
		foreach ($files as $file) {
			//Make sure that this is a file and not a directory.
			if (is_file($file)) {
				//Use the unlink function to delete the file.
				unlink($file);
			}
		}
	}

	public function enablePackages()
	{
		$active_theme = setting('theme-active', config('themes.active'));
		$function = Themes::getJsonContents($active_theme, 'functions');
		if(array_key_exists('packages', $function)){
			foreach($function['packages'] as $package) {
				if(Module::exists($package['slug'])) {
					Module::enable($package['slug']);
				}
			}
		}
	}


	public function disablePackages()
	{
		$active_theme = setting('theme-active', config('themes.active'));
		$function = Themes::getJsonContents($active_theme, 'functions');
		if(array_key_exists('packages', $function)){
			foreach($function['packages'] as $package) {
				if(Module::exists($package['slug'])) {
					Module::disable($package['slug']);
				}
			}
		}
	}
	

}
