<?php

namespace App\Repositories\Backend;

use App\Repositories\Repository;
use App\Models\Comment\Comment;
use Illuminate\Database\Eloquent\Model;

/**
 * Class CommentRepository
 * @package App\Repositories\Backend
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class CommentRepository extends Repository
{
    /**
     * Associated Repository Model
     */
    const MODEL = Comment::class;

    /**
     * @param bool $trashed
     * @return mixed
     */
    public function getForDataTable($trashed = false)
    {
        /**
         * Note: You must return deleted_at or the User getActionButtonsAttribute won't
         * be able to differentiate what buttons to show for each row.
         */
        $dataTableQuery = $this->query()
            ->select([
                'id',
                'comment',
                'status',
                'created_at',
                'updated_at',
                'deleted_at'
            ])
            ->orderBY('id','desc');

        if ($trashed == "true") {
            return $dataTableQuery->onlyTrashed();
        }

        return $dataTableQuery;
    }

    public function emptyTrash()
    {
        $this->query()->onlyTrashed()->forceDelete();
        return true;
    }

    public function status(Model $comment, $status)
    {
        $comment->status = $status;
        $comment->save();
        return true;
    }


}
