<?php

namespace App\Repositories\Backend;

use App\Models\Block\Block;
use App\Models\Widget\Widget;
use App\Repositories\Repository;
use App\Exceptions\GeneralException;
use Illuminate\Database\Eloquent\Model;

/**
 * Class BlockRepository
 * @package App\Repositories\Backend
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */

class BlockRepository extends Repository
{
    /**
     * Associated Repository Model
     */
    const MODEL = Block::class;

    /**
     * @param bool $trashed
     * @return mixed
     */
    public function getForDataTable($trashed = false)
    {
        /**
         * Note: You must return deleted_at or the User getActionButtonsAttribute won't
         * be able to differentiate what buttons to show for each row.
         */
        $dataTableQuery = $this->query()
            ->select([
                'id',
                'title',
                'slug',
                'show_title',
                'status',
                'created_at',
                'updated_at'
            ])
            ->orderBY('id','desc');

        return $dataTableQuery;
    }

    /**
     * @param $data
     * @throws GeneralException
     */
    public function  create($data)
    {
        $block = self::MODEL;
        $block = new $block;
        $block->title = $data['title'];
        $block->content = $data['content'];
        $block->show_title = (isset($data['show'])) ? '1' : '0';
        $block->status = ($data['status']=='1') ? '1' : '0';
        if(parent::save($block))
            return true;

        throw new GeneralException('There is some error occured during adding new block');
    }

    /**
     * @param Model $block
     * @param array $input
     */
    public function update(Model $block, array $input)
    {
        $data = array();
        $data['title'] = $input['title'];
        $data['content'] = $input['content'];
        $data['slug'] = $input['slug'];

        $data['show_title'] = (isset($input['show'])) ? '1' : '0';
        $data['status'] = ($input['status'] == '1') ? '1' : '0';


        if (parent::update($block, $data)) {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.block.update_error'));
    }

    /**
     * @param Model $block
     * @return bool
     * @throws GeneralException
     */
    public function delete(Model $block)
    {
        if (parent::delete($block)) {
            Widget::where('content', $block->slug)->where('type','block')->delete();
            return true;
        }

        throw new GeneralException('There is some error occured during deleting block.');
    }


}