<?php

namespace App\Providers;

use App\Shortcodes\GalleryShortcode;
use Shortcode;
use App\Shortcodes\BoldShortcode;
use App\Shortcodes\ContactShortcode;
use App\Shortcodes\BlockShortcode;
use App\Shortcodes\MapShortcode;
use App\Shortcodes\FileShortcode;
use Illuminate\Support\ServiceProvider;

class ShortcodesServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        Shortcode::register('b', BoldShortcode::class);
        Shortcode::register('contact', ContactShortcode::class);
        Shortcode::register('block', BlockShortcode::class);
        Shortcode::register('map', MapShortcode::class);
        Shortcode::register('file', FileShortcode::class);
        Shortcode::register('gallery', GalleryShortcode::class);
    }
}
