<?php

namespace App\Providers;

use App\Models\Access\User\User;
use App\Models\Comment\Comment;
use App\Models\Post\Post;
use App\Models\Slider\SliderItem;
use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * This namespace is applied to your controller routes.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'App\Http\Controllers';

    /**
     * The path to the "home" route for your application.
     *
     * @var string
     */
    public const HOME = '/admin';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @return void
     */
    public function boot()
    {
        $this->configureRateLimiting();

        /*
         * This allows us to use the Route Model Binding with SoftDeletes on
         * On a model by model basis
         */
        $this->bind('deletedUser', function ($value) {
            $user = new User();

            return User::withTrashed()->where($user->getRouteKeyName(), $value)->first();
        });

        $this->bind('deletedPage', function ($value) {
            $page = new Post();

            return Post::withTrashed()->where($page->getRouteKeyName(), $value)->first();
        });

        $this->bind('deletedBlog', function ($value) {
            $blog = new Post();

            return Post::withTrashed()->where($blog->getRouteKeyName(), $value)->first();
        });

        $this->bind('sliderItem', function ($value) {
            $sliderItem = new SliderItem();

            return SliderItem::where('id', $value)->first();
        });

        $this->bind('deletedComment', function ($value) {
            $comment = new Comment();

            return Comment::withTrashed()->where($comment->getRouteKeyName(), $value)->first();
        });

        $this->routes(function () {
            Route::middleware('web')
                ->namespace($this->namespace)
                ->group(base_path('routes/web.php'));

            Route::prefix('api')
                ->middleware('api')
                ->namespace($this->namespace)
                ->group(base_path('routes/api.php'));
        });
    }

    /**
     * Configure the rate limiters for the application.
     *
     * @return void
     */
    protected function configureRateLimiting()
    {
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by(optional($request->user())->id ?: $request->ip());
        });
    }
}
