<?php

namespace App\Providers;

use App\Events\Backend\Blog\BlogCreated;
use App\Events\Backend\Blog\BlogDeleted;
use App\Events\Backend\Blog\BlogUpdated;
use App\Events\Backend\Page\PageCreated;
use App\Events\Backend\Page\PageDeleted;
use App\Events\Backend\Page\PageUpdated;
use App\Listeners\Backend\SitemapGenerate;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        BlogCreated::class => [
            SitemapGenerate::class
        ],
        BlogUpdated::class => [
            SitemapGenerate::class
        ],
        BlogDeleted::class => [
            SitemapGenerate::class
        ],
        PageCreated::class => [
            SitemapGenerate::class
        ],
        PageUpdated::class => [
            SitemapGenerate::class
        ],
        PageDeleted::class => [
            SitemapGenerate::class
        ]
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
