<?php

namespace App\Providers;

use App\Services\Tree;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(
            base_path('config/admin-menu.php'),
            'menu.admin'
        );
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Schema::defaultStringLength(191);

        Paginator::useBootstrap();
        $this->composeView();

        if($this->app->environment('production') && config('access.secure')) {
            \URL::forceScheme('https');
        }
    }

    protected function composeView()
    {
        view()->composer('admin.includes.sidebar', function ($view) {
            $tree = Tree::create();

            foreach (config('menu.admin') as $index => $item) {
                $tree->add($item, 'menu');
            }


            $tree->items = $tree->sortItems($tree->items);

            $view->with('menu', $tree);
        });
    }
}
