<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| This file is where you may define all of the routes that are handled
| by your module. Just tell Laravel the URIs it should respond
| to using a Closure or controller method. Build something great!
|
*/
Route::group(['as' => 'admin.', 'prefix' => 'admin', 'middleware' => 'auth'], function () {
    Route::get('contact', 'ContactController@index')->name('contact.index');
    Route::get('contact/create', 'ContactController@create')->name('contact.create');
    Route::post('contact/store', 'ContactController@store')->name('contact.store');
    Route::get('contact/{id}/edit', 'ContactController@edit')->name('contact.edit');
    Route::put('contact/{id}/update', 'ContactController@update')->name('contact.update');
    Route::get('contact/{id}', 'ContactController@show')->name('contact.show');
    Route::delete('contact/{id}', 'ContactController@delete')->name('contact.delete');
});

Breadcrumbs::for('admin.contact.index', function ($trail) {
    $trail->push('Contact', route('admin.contact.index'));
});

Breadcrumbs::for('admin.contact.create', function ($trail) {
    $trail->parent('admin.contact.index');
    $trail->push('Create', route('admin.contact.create'));
});

Breadcrumbs::for('admin.contact.edit', function ($trail, $id) {
    $trail->parent('admin.contact.index');
    $trail->push('Edit', route('admin.contact.edit', $id));
});

Breadcrumbs::for('admin.contact.show', function ($trail, $id) {
    $trail->push('Contact Responses', route('admin.contact.show', $id));
});
