@extends ('admin.layouts.app')

@section ('title', 'Contact Form')

@section('after-styles')

@stop

@section('page-header')
    <h1>
        Contact Form
    </h1>
@endsection

@section('content')
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">Contact Forms</h3>

            <div class="card-tools float-right">
                <!-- Include your header buttons  -->
                {{ link_to_route('admin.contact.create','Add Form', [], ['class' => 'btn btn-success btn-xs']) }}
            </div><!--box-tools pull-right-->
        </div><!-- /.box-header -->

        <div class="card-body">
            <div class="table-responsive">
                <table id="contact-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th>{{ trans('labels.backend.table.id') }}</th>
                        <th>{{ trans('labels.backend.table.title') }}</th>
                        <th>Shortcode</th>
                        <th>Receiver Email</th>
                        <th>Status</th>
                        <th>Responses</th>
                        <th>{{ trans('labels.backend.table.created') }}</th>
                        <th>{{ trans('labels.general.actions') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                        @forelse($contact_forms as $contact_form)
                            <tr>
                                <td>{{$contact_form->id}}</td>
                                <td>{{$contact_form->name}}</td>
                                <td>
                                    Shortcode: [contact key={{$contact_form->slug}}] <a href="#" class="clipboard" data-text="[contact key={{$contact_form->slug}}]">copy</a>
                                </td>
                                <td>{{$contact_form->receiver_email}}</td>
                                <td>{!!$contact_form->label('status', 'Active|Deactive')!!}</td>
                                <td>{{$contact_form->responses()->count()}}</td>
                                <td>{{$contact_form->created_at->diffForHumans()}}</td>
                                <td>{!!$contact_form->action_buttons!!}</td>
                            </tr>

                        @empty
                        <tr>
                            <td colspan="8" class="text-center">No contacts found...</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
                {!! $contact_forms->links() !!}
            </div><!--table-responsive-->
        </div><!-- /.box-body -->
    </div><!--box-->

@stop

@push('after-scripts')
 <script>
     $(document).on('click', '.clipboard', function(e) {
        var _this = $(this);
        var text = $(this).data('text');
        navigator.clipboard.writeText(text).then(() => {
            _this.text('copied');
        });
    });
 </script>
@endpush
