<?php
namespace App\Modules\Contact\Models;

/**
 * Class ContactAttributes
 * @package App\Modules\Events\Models
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
trait ContactAttributes
{

    /**
     * @return string
     */
    public function getResponseButtonAttribute()
    {
        return '<a href="'.route('admin.contact.show', $this).'" class="btn btn-xs btn-success">Response</a> ';
    }
    /**
     * @return string
     */
    public function getEditButtonAttribute()
    {
        return '<a href="'.route('admin.contact.edit', $this).'" class="btn btn-xs btn-primary"><i class="fa fa-pencil-alt" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.edit') . '"></i></a> ';
    }

    /**
     * @return string
     */
    public function getDeleteButtonAttribute()
    {
        return '<a href="' . route('admin.contact.delete', $this) . '"
                 data-method="delete"
                 data-trans-button-cancel="' . trans('buttons.general.cancel') . '"
                 data-trans-button-confirm="' . trans('buttons.general.crud.delete') . '"
                 data-trans-title="' . trans('strings.backend.general.are_you_sure') . '"
                 class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.delete') . '"></i></a> ';

    }

    /**
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return
        $this->getResponseButtonAttribute() .
        $this->getEditButtonAttribute() .
        $this->getDeleteButtonAttribute();
    }
}
