<?php

namespace App\Modules\Citytracking\Providers;

use Illuminate\Support\Facades\Event;
use Caffeinated\Modules\Support\ServiceProvider;

class ModuleServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the module services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadTranslationsFrom(module_path('citytracking', 'Resources/Lang', 'app'), 'citytracking');
        $this->loadViewsFrom(module_path('citytracking', 'Resources/Views', 'app'), 'citytracking');
        $this->loadMigrationsFrom(module_path('citytracking', 'Database/Migrations', 'app'));
        if(!$this->app->configurationIsCached()) {
            $this->loadConfigsFrom(module_path('citytracking', 'Config', 'app'));
        }
        $this->loadFactoriesFrom(module_path('citytracking', 'Database/Factories', 'app'));

        Event::listen('cityremit.tracking.form', function($eventManager) {
            $eventManager->addTemplate('citytracking::trackingform');
        });
        Event::listen('cityremit.tracking.scripts', function($eventManager) {
            $eventManager->addTemplate('citytracking::scripts');
        });
    }

    /**
     * Register the module services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
    }
}
