<?php
namespace  App\Models\Widget;
/**
 * Class Widget
 * @package app\Models\Widget
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 * @date 12/20/16
 * @time 8:08 PM
 */

use App\Models\Block\Block;
use App\Services\Sluggable;
use App\Models\Widget\WidgetAttribute;
use Illuminate\Database\Eloquent\Model;

class Widget extends Model
{
    use Sluggable, WidgetAttribute;
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = 'widgets';
    }

    public function sluggable() {
        return [
            'source' => 'title',
        ];
    }

    
}