<?php
namespace App\Models\Tag;

/**
 * Class Tag
 * @package App\Models\Tag
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 * @date 12/20/16
 * @time 8:08 PM
 */

use App\Models\Post\Post;
use App\Models\Tag\TagAttributes;
use Illuminate\Database\Eloquent\Model;
use App\Services\Sluggable;

class Tag extends Model
{

    use TagAttributes, Sluggable;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = 'tags';
    }


    /**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable() : array
    {
        return [
            'source' => 'title',
        ];
    }

    public function posts()
    {
        return $this->belongsToMany(Post::class);
    }

    public static function add($tags) {
        $ids = [];
        foreach($tags as $tag) {
            if($tag != '' ){
                $tag = Tag::firstOrCreate(['title' => $tag]);
                $ids[] = $tag->id;
            }
        }
        return $ids;
    }
}
