<?php

namespace App\Models\Slider;

/*
 * Class SliderItem
 * @package app\Models\SliderItem
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 * @date 12/20/16
 * @time 8:08 PM
 */

use App\Models\Media\Media;
use Illuminate\Database\Eloquent\Model;

class SliderItem extends Model
{
    use SliderItemAttribute;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = 'slider_items';
    }

    public function media()
    {
        return $this->belongsTo(Media::class);
    }
}
