<?php

namespace App\Models\Review;

use DB;

/**
 * Class Reviewttribute
 * @package App\Models\Review
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
trait ReviewAttribute
{

    public function getImageAttribute()
    {
        return public_asset('images/default-user.png');
    }

    public function getApproveButtonAttribute()
    {
        switch ($this->status) {
            case '0':
                return '<a href="' . route('admin.review.status', [
                    $this,
                    '1'
                ]) . '" class="btn btn-xs btn-success"><i class="fa fa-check" data-toggle="tooltip" data-placement="top" title="Approve"></i></a> ';
            // No break

            case '1':
                return '<a href="' . route('admin.review.status', [
                    $this,
                    '0'
                ]) . '" class="btn btn-xs btn-warning"><i class="fa fa-pause" data-toggle="tooltip" data-placement="top" title="Un-Approve"></i></a> ';
            // No break

            default:
                return '';
            // No break
        }
       

        return '';
    }

    /**
     * @return string
     */
    public function getEditButtonAttribute()
    {
        return '<a href="'.route('admin.review.edit', $this).'" class="btn btn-xs btn-primary"><i class="fa fa-pencil-alt" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.edit') . '"></i></a> ';
    }


    /**
     * @return string
     */
    public function getDeleteButtonAttribute()
    {
        return '<a href="' . route('admin.review.destroy', $this) . '"
                 data-method="delete"
                 data-trans-button-cancel="' . trans('buttons.general.cancel') . '"
                 data-trans-button-confirm="' . trans('buttons.general.crud.delete') . '"
                 data-trans-title="' . trans('strings.backend.general.are_you_sure') . '"
                 class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.delete') . '"></i></a> ';

    }

    /**
     * @return string
     */
    public function getRestoreButtonAttribute()
    {
        return '<a href="' . route('admin.blog.restore', $this) . '" name="restore_blog" class="btn btn-xs btn-info"><i class="fa fa-refresh" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.blog.restore_blog') . '"></i></a> ';
    }

    /**
     * @return string
     */
    public function getDeletePermanentlyButtonAttribute()
    {
        return '<a href="' . route('admin.blog.delete-permanently', $this) . '" name="delete_blog_perm" class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.general.delete_permanently') . '"></i></a> ';
    }


    /**
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return
            $this->getApproveButtonAttribute() .
            $this->getEditButtonAttribute() .
            $this->getDeleteButtonAttribute();
    }
}