<?php
namespace App\Models\Review;

use App\Models\Product\Product;
use App\Services\Sluggable;
use App\Models\Review\ReviewAttribute;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Review
 * @package App\Models\Review
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class Review extends Model
{
    use Sluggable, ReviewAttribute;
    
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

     /**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    
    /**
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = 'reviews';
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function sluggable() {
        return [
            'source' => 'title',
        ];
    }

}
