<?php

namespace App\Models\Gallery;

/**
 * Class GalleryAttributes
 * @package App\Models\Gallery
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
trait GalleryAttributes
{

    public function getAddButtonAttribute()
    {
        return '<a href="' . route('admin.gallery.item.create', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-plus" data-toggle="tooltip" data-placement="top" title="Add Items in Gallery"></i></a> ';
    }

    public function getShowButtonAttribute()
    {
        return '<a href="' . route('admin.gallery.item.index', $this) . '" class="btn btn-xs btn-success"><i class="fa fa-eye" data-toggle="tooltip" data-placement="top" title="View Items of Gallery"></i></a> ';
    }


    /**
     * @return string
     */
    public function getEditButtonAttribute()
    {
        return '<a href="'.route('admin.gallery.edit', $this).'" class="btn btn-xs btn-primary"><i class="fa fa-pencil-alt" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.edit') . '"></i></a> ';
    }

    /**
     * @return string
     */
    public function getDeleteButtonAttribute()
    {
        return '<a href="' . route('admin.gallery.delete', $this) . '"
                 data-method="delete"
                 data-trans-button-cancel="' . trans('buttons.general.cancel') . '"
                 data-trans-button-confirm="' . trans('buttons.general.crud.delete') . '"
                 data-trans-title="' . trans('strings.backend.general.are_you_sure') . '"
                 class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.delete') . '"></i></a> ';

    }

    /**
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return
        $this->getEditButtonAttribute() .
        $this->getDeleteButtonAttribute();
    }
}
