<?php

namespace App\Models\Comment;

/**
 * Class CommentAttribute
 * @package App\Models\Comment
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
trait CommentAttribute
{
	public function getNameAttribute()
	{
		if($this->guest) {
			return 'Anonymous User';
		}
		return $this->user->name;
	}

	/**
     * @return string
     */
    public function getStatusUpdateButtonAttribute()
    {
       if($this->status == 1) {
           return '<a href="' . route('admin.comments.status.unapprove', $this) . '" class="btn btn-xs btn-warning"><i class="fa fa-redo" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.comment.unapprove_comment') . '"></i></a> ';
       }
       return '<a href="' . route('admin.comments.status.approve', $this) . '" class="btn btn-xs btn-info"><i class="fa fa-redo" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.comment.approve_comment') . '"></i></a> ';
    }


	/**
     * @return string
     */
    public function getDeleteButtonAttribute()
    {          
		return '<a href="' . route('admin.comments.destroy', $this) . '"
			data-method="delete"
			data-trans-button-cancel="' . trans('buttons.general.cancel') . '"
			data-trans-button-confirm="' . trans('buttons.general.crud.delete') . '"
			data-trans-title="' . trans('strings.backend.general.are_you_sure') . '"
			class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="Trash"></i></a> ';
    }

    /**
     * @return string
     */
    public function getRestoreButtonAttribute()
    {
        return '<a href="' . route('admin.comments.restore', $this) . '" name="restore_comment" class="btn btn-xs btn-info"><i class="fa fa-redo" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.comment.restore_comment') . '"></i></a> ';
    }

    /**
     * @return string
     */
    public function getDeletePermanentlyButtonAttribute()
    {  
        return '<a href="' . route('admin.comments.delete-permanently', $this) . '" name="delete_comment_perm" class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.general.delete_permanently') . '"></i></a> ';

    }


    /**
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        if ($this->trashed()) {
            return $this->getRestoreButtonAttribute() .
                $this->getDeletePermanentlyButtonAttribute();
        }

        return
            $this->getDeleteButtonAttribute().
            $this->getStatusUpdateButtonAttribute();
    }
}