<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ContactMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $contact;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(array $contact)
    {
        $this->contact = $contact;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $subject = setting('site-title','Seshra Notifications');
        if(array_key_exists('title', $this->contact)){
            $arr = explode(' ',trim($subject));
            $subject =$arr[0].' : '. $this->contact['title'];
        }
        return $this->subject($subject)->view('admin.mail.contact')->withContacts($this->contact);

    }
}
