<?php

namespace App\Http\Requests\Backend\Blog;

use App\Http\Requests\Request;

/**
 * Class StoreBlogRequest
 * @package App\Http\Requests\Backend\Blog
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class StoreBlogRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth()->user()->hasPermission('edit-blogs');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required'
        ];
    }
}
