<?php

namespace App\Http\Requests\Backend\Blog;

use App\Http\Requests\Request;

/**
 * Class DeleteBlogRequest
 * @package App\Http\Requests\Backend\Blog
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class DeleteBlogRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if(!auth()->user()->hasRole(1) && auth()->user()->hasRole('Author')) {
            if($this->post->user_id != auth()->id()) {
                return false;
            }
            return true;
        }
        return auth()->user()->hasPermission('delete-blogs');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            //
        ];
    }
}
