<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Product\Product;
use Illuminate\Http\Request;
use Theme;

/**
 * Class SearchController.
 *
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class SearchController extends FrontendController
{
    public function search(Request $request)
    {
        $products = [];
        if ($request->cat == '0') {
            $products = Product::search($request->s)->paginate(10);
        } else {
            $products = Product::search($request->s, ['name' => 10, 'description' => 5])->select('products.*')->leftJoin('product_relation_category', 'product_relation_category.product_id', '=', 'products.id')->leftJoin('product_categories', 'product_relation_category.category_id', '=', 'product_categories.id')->where('product_categories.slug', $request->cat)->paginate(9);
        }

        return Theme::view('search')->withProducts($products);
    }
}
