<?php

namespace App\Http\Controllers\Backend;

use DB;
use File;
use Illuminate\Http\Request;
use Setting;

/**
 * Class SettingController.
 *
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class SettingController extends BaseController
{
    /**
     * @param null
     *
     * @return view
     */
    public function general()
    {
        return view($this->theme('settings.general'));
    }

    /**
     * @return mixed
     */
    public function generalUpdate(Request $request)
    {
        Setting::set('site-title', $request->site_title);
        Setting::set('site-tagline', $request->site_tagline);
        Setting::set('site-phone', $request->site_phone);
        Setting::set('site-info', $request->site_info);
        Setting::set('site-address', $request->site_address);
        Setting::set('site-address-url', $request->site_address_url);
        Setting::set('site-email', $request->site_email);
        Setting::set('site-logo', $request->site_logo);
        Setting::set('site-logo-dark', $request->site_logo_dark);
        Setting::set('favicon', $request->favicon);

        return redirect()->route('admin.settings.general')->withFlashSuccess(trans('alerts.backend.general.updated', ['attribute' => 'general settings']));
    }

    /**
     * @param null
     *
     * @return view
     */
    public function seo()
    {
        return view($this->theme('settings.seo'));
    }

    /**
     * @return mixed
     */
    public function seoUpdate(Request $request)
    {
        Setting::set('meta-description', $request->meta_description);
        Setting::set('meta-keywords', $request->meta_keywords);

        return redirect()->route('admin.setting.seo')->withFlashSuccess(trans('alerts.backend.general.updated', ['attribute' => 'seo settings']));
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function miscellaneous()
    {
        return view($this->theme('settings.miscellaneous'));
    }

    /**
     * @return mixed
     */
    public function miscellaneousUpdate(Request $request)
    {
        //AdminBar###############################
        if ($request->admin_bar == 'yes') {
            Setting::set('admin-bar', 1);
        } else {
            Setting::set('admin-bar', 0);
        }

        //AdminLayout###############################
        if ($request->admin_layout == 'admin') {
            Setting::set('admin-layout', 'admin');
        } else {
            Setting::set('admin-layout', 'backend');
        }

        //Disqus Comment#########################
        if ($request->disqus == 'enable') {
            Setting::set('disqus', true);
        } else {
            Setting::set('disqus', false);
        }
        Setting::set('disqus-username', $request->disqus_username);

        //Messenger Chat Plugin ##################
        if ($request->messenger_chat == 'enable') {
            Setting::set('messenger-chat', true);
        } else {
            Setting::set('messenger-chat', false);
        }
        Setting::set('facebook-page-id', $request->facebook_page_id);
        Setting::set('messenger-chat-display-page', $request->messenger_chat_display_page);

        //AddThis ###############################
        if ($request->addthis_share == 'enable') {
            Setting::set('addthis-share', true);
        } else {
            Setting::set('addthis-share', false);
        }
        Setting::set('addthis-profile-id', $request->addthis_profile_id);

        return redirect()->route('admin.setting.miscellaneous')->withFlashSuccess(trans('alerts.backend.general.updated', ['attribute' => 'miscellaneous settings']));
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function backup()
    {
        File::delete('larapress.sql');

        return view($this->theme('settings.backup'));
    }

    public function backupLarapress(Request $request)
    {
        \Spatie\DbDumper\Databases\MySql::create()
            ->setDumpBinaryPath('C:\MAMP\bin\mysql\bin')
            ->setDbName(config('database.connections.mysql.database'))
            ->setUserName(config('database.connections.mysql.username'))
            ->setPassword(config('database.connections.mysql.password'))
            ->includeTables(['categories', 'posts', 'category_post', 'comments', 'comment_post', 'menus', 'menuitems', 'media'])
            ->dumpToFile('larapress.sql');

        return response()->download('larapress.sql', 'larapress.sql');
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function restore()
    {
        return view($this->theme('settings.restore'));
    }

    /**
     * @param null
     *
     * @return view
     */
    public function customCss()
    {
        $theme_name = setting('theme-active', config('themes.active')).'-customcss';
        $css = setting($theme_name);
        return view($this->theme('settings.custom_css'), compact('css'));
    }

    /**
     * @return mixed
     */
    public function customCssUpdate(Request $request)
    {
        $theme_css_name =  setting('theme-active', config('themes.active')).'-customcss';
        Setting::set($theme_css_name, $request->css);

        return redirect()->route('admin.setting.custom_css')->withFlashSuccess(trans('alerts.backend.general.updated', ['attribute' => 'custom css']));
    }
}
