<?php

namespace App\Http\Controllers\Backend\Search;

use App\Http\Controllers\Backend\BaseController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

/**
 * Class SearchController
 * @package App\Http\Controllers\Backend\Search
 */
class SearchController extends BaseController
{

	/**
	 * @param Request $request
	 * @return mixed
	 */
	public function index(Request $request)
	{
		if (! $request->has('q'))
			return redirect()
				->route('admin.dashboard')
				->withFlashDanger(trans('strings.backend.search.empty'));

		/**
		 * Process Search Results Here
		 */
		$results = null;

		return view($this->theme('search.index'))
			->withSearchTerm($request->get('q'))
			->withResults($results);
	}
}