<?php
namespace App\Http\Controllers\Backend;

use Artisan;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Repositories\Backend\PackageRepository;

/**
 * Class PackageController
 * @package App\Http\Controllers\Backend
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class PackageController extends BaseController
{
    
    /**
     * @var PackageRepository
     */
    protected $package;

    /**
     * @param PackageRepository $package
     */
    public function __construct(PackageRepository $package)
    {
        $this->package = $package;
    }

    /**
     * Get all packages
     *
     * @return view
     */
    public function index()
    {
        $modules = $this->package->getModules();
        return view($this->theme('packages.index'), compact('modules'));
    }

    /**
     * Activate package
     *
     * @param string $package_name
     * @return void
     */
    public function activate($package_name)
    {
        $this->package->enable($package_name);
        return redirect()->back()->withFlashSuccess(ucfirst($package_name).' package activated successfully.');
    }

    /**
     * Deactivate package
     *
     * @param string $package_name
     * @return void
     */
    public function deactivate($package_name)
    {
        $this->package->disable($package_name);
        return redirect()->back()->withFlashSuccess(ucfirst($package_name) . ' package deactivated successfully.');
    }

    /**
     * Delete package
     *
     * @param string $package_name
     * @return void
     */
    public function delete($package_name)
    {
        $this->package->delete($package_name);
        return redirect()->back()->withFlashSuccess(ucfirst($package_name).' package has been deleted successfully.');
    }

    /**
     * Upload package
     *
     * @param Request $request
     * @return void
     */
    public function upload(Request $request)
    {
        $this->package->deleteAllFiles(storage_path('app/packages'));
        $file = $request->file('package');;
        $path = $file->storeAs('packages', $file->getClientOriginalName());
        if($this->package->extract($path)) {
            return redirect()->back()->withFlashSuccess('Package has been uploaded successfully');
        }
        return redirect()->back()->withFlashDanger('Invalid package');
    }
}