<?php

namespace App\Http\Controllers\Backend;

use App\Models\Gallery\Gallery;
use App\Models\Gallery\GalleryItem;
use DataTables;
use Illuminate\Http\Request;
use Rawbinn\Media\Models\Media;
use Validator;

/**
 * Class GalleryController.
 *
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class GalleryController extends BaseController
{
    /**
     * @return View
     */
    public function index()
    {
        $galleries = Gallery::where('type', 'image')->paginate(10);
        return view($this->theme('gallery.index'), compact('galleries'));
    }

    /**
     * @return View
     */
    public function create()
    {
        return view($this->theme('gallery.create'));
    }

    /**
     * @return mixed
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required'
        ]);

        $gallery = new Gallery();
        $gallery->title = $request->title;
        $gallery->user_id = auth()->id();
        if ($gallery->save()) {
            if ($request->images) {
                $image_ids = explode(',', $request->images);
                foreach ($image_ids as $image_id) {
                    $media = Media::find($image_id);
                    if ($media) {
                        GalleryItem::create([
                            'gallery_id' => $gallery->id,
                            'image_id' => $media->id,
                        ]);
                    }
                }
            }

            return redirect()->route('admin.gallery.index')->withFlashSuccess('New gallery added successfully.');
        }
    }

    /**
     * @param $id
     *
     * @return View
     */
    public function edit($id)
    {
        $gallery = Gallery::find($id);

        return view($this->theme('gallery.edit'))->withGallery($gallery);
    }

    /**
     * @param $id
     *
     * @return mixed
     */
    public function update($id, Request $request)
    {
        $request->validate([
            'title' => 'required',
            'key' => 'required|unique:gallery,slug,'.$id
        ]);

        $gallery = Gallery::find($id);
        $gallery->title = $request->title;
        $gallery->slug = $request->key;
        if ($gallery->save()) {
            if($request->images === null) {
                GalleryItem::where('gallery_id', $gallery->id)->delete();
            }
            else {
                GalleryItem::where('gallery_id', $gallery->id)->delete();
                $image_ids = explode(',', $request->images);
                foreach ($image_ids as $image_id) {
                    $media = Media::find($image_id);
                    if ($media) {
                        GalleryItem::create([
                            'gallery_id' => $gallery->id,
                            'image_id' => $media->id,
                        ]);
                    }
                }
            }

            return redirect()->back()->withFlashSuccess('Gallery updated successfully.');
        }
    }

    public function delete($id)
    {
        $gallery = Gallery::find($id);
        if ($gallery->delete()) {
            $gallery->items()->delete();

            return redirect()->back()->withFlashSuccess('Gallery deleted successfully.');
        }

        return redirect()->back()->withFlashDanger('There is some error occured during deleting data.');
    }

}
