<?php

namespace App\Http\Controllers\Backend;

use App\Models\Post\PostMeta;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

/**
 * Class DynamicBlockController.
 *
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class DynamicBlockController extends BaseController
{
    public function addBlock(Request $request)
    {
        $data['cols'] = $request->cols;
        $data['column'] = 12/$request->cols;
        $data['block'] = $request->block;
        $data['name'] = 'block-'.$request->block;
        $data['lang'] = app()->getLocale();
        return view('admin.dynamic_block.block', $data);
    }

    public function getBlock(Request $request)
    {
        $data = [
            'col' => $request->col,
            'cols' => $request->cols,
            'type' => $request->type,
            'block' => $request->block,
            'item' => $request->item,
            'name' => 'block_'.$request->block
        ];

        if ($data['type'] == 'title_block') {
            return view('admin.dynamic_block.title_block', $data);
        } elseif ($data['type'] == 'title_subtitle_block') {
            return view('admin.dynamic_block.title_subtitle_block', $data);
        } elseif ($data['type'] == 'text_block') {
            return view('admin.dynamic_block.text_block', $data);
        } elseif ($data['type'] == 'text_block_with_title') {
            return view('admin.dynamic_block.text_block_title', $data);
        } elseif ($data['type'] == 'text_block_with_title_and_image') {
            return view('admin.dynamic_block.text_block_title_image', $data);
        } elseif ($data['type'] == 'list_block') {
            return view('admin.dynamic_block.list_block', $data);
        } elseif ($data['type'] == 'text_list_block_without_image') {
            return view('admin.dynamic_block.text_list_block', $data);
        } elseif ($data['type'] == 'text_list_block_with_image') {
            return view('admin.dynamic_block.text_list_block_image', $data);
        } elseif ($data['type'] == 'list_block_with_title_image_url') {
            return view('admin.dynamic_block.list_block_title_image_url', $data);
        } elseif ($data['type'] == 'list_block_with_title_image') {
            return view('admin.dynamic_block.list_block_title_image', $data);
        } elseif ($data['type'] == 'accordion_block') {
            return view('admin.dynamic_block.accordion_block', $data);
        } elseif ($data['type'] == 'our_team_block') {
            return view('admin.dynamic_block.our_team_block', $data);
        } elseif ($data['type'] == 'our_unit_head_block') {
            return view('admin.dynamic_block.our_unit_head_block', $data);
        } elseif ($data['type'] == 'download_block') {
            return view('admin.dynamic_block.download_block', $data);
        } elseif ($data['type'] == 'country_list_block') {
            return view('admin.dynamic_block.country_list_block', $data);
        } elseif ($data['type'] == 'timeline_block') {
            return view('admin.dynamic_block.timeline_block', $data);
        }
    }

    public function deleteBlockItem(Request $request)
    {
        $validator = Validator::make($request->all(), [
			'key' => 'required',
            'pid' => 'required|numeric',
            'col' => 'required|numeric',
            'item' => 'required|numeric'
        ]);
        if ($validator->fails()) {
            $errors = $validator->messages()->all();
            return response()->json(['status' => false, 'message' => $errors[0], 'data' => []]);
        }
        try {
            $post_metas = PostMeta::where('post_id', $request->pid)->where('key', $request->key)->get();
            if(!$post_metas->isEmpty()) {
                foreach($post_metas as $post_meta) {
                    $data = json_decode($post_meta->value, true);
                    $selectedColumn = $data[$request->col] ?? [];
                    if(count($selectedColumn) > 0){
                        unset($selectedColumn[$request->item]);
                        $data[$request->col] = $selectedColumn;
                    }
                    $post_meta->value  = json_encode($data);
                    $post_meta->save();
                }
                
            }
        }catch(\Exception $e) {
            return response()->json(['status' => false]);
        }
        return response()->json(['status' => true]);
    }

    public function deleteBlock(Request $request)
    {
        $validator = Validator::make($request->all(), [
			'key' => 'required',
            'pid' => 'required|numeric'
        ]);
        if ($validator->fails()) {
            $errors = $validator->messages()->all();
            return response()->json(['status' => false, 'message' => $errors[0], 'data' => []]);
        }
        try{
            $post_metas = PostMeta::where('post_id', $request->pid)->where('key', $request->key)->get();
            if(!$post_metas->isEmpty()) {
                foreach($post_metas as $post_meta) {
                    $post_meta->delete();
                }
            }
        }catch(\Exception $e) {
            return response()->json(['status' => false]);
        }
        return response()->json(['status' => true]);
    }

    public function sortBlock(Request $request)
    {
        $validator = Validator::make($request->all(), [
			'key' => 'required',
            'pid' => 'required|numeric',
            'sort' => 'required|in:up,down'
        ]);
        if ($validator->fails()) {
            $errors = $validator->messages()->all();
            return response()->json(['status' => false, 'message' => $errors[0], 'data' => []]);
        }
        try{
            $post_meta = PostMeta::where('post_id', $request->pid)->where('key', $request->key)->first();
            if($post_meta) {
                if($request->sort == 'up') {
                    // $post_meta_up = PostMeta::where('post_id', $request->pid)->where('sort', '<=', $post_meta->sort)->orderBy('sort', 'DESC')->first();
                    
                    // if($post_meta_up) {
                        // $post_meta_up->sort = $post_meta_up->sort +1 ;
                        // $post_meta_up->save();
                        $post_meta->sort = ($post_meta->sort - 1) < 0 ? 0 : ($post_meta->sort - 1);
                    // }
                } else {
                    // $post_meta_down = PostMeta::where('post_id', $request->pid)->where('sort', '>=', $post_meta->sort)->orderBy('sort', 'DESC')->first();
                    // if($post_meta_down) {
                        // $post_meta_down->sort = ($post_meta_down->sort - 1) < 0 ? 0 : ($post_meta_down->sort - 1);
                        // $post_meta_down->save();
                        $post_meta->sort = $post_meta->sort + 1;
                    // }
                }
                $post_meta->save();
            }
        }catch(\Exception $e) {
            return response()->json(['status' => false, 'message' => $e->getMessage()]);
        }
        return response()->json(['status' => true]);
    }

}
