<?php
namespace App\Http\Controllers\Backend;

use App\Models\Comment\Comment;
use App\Http\Controllers\Controller;
use DataTables;
use App\Repositories\Backend\CommentRepository;
use App\Http\Requests\Backend\Comment\StoreCommentRequest;
use App\Http\Requests\Backend\Comment\UpdateCommentRequest;
use App\Http\Requests\Backend\Comment\ManageCommentRequest;

/**
 * Class CommentController
 * @package App\Http\Controllers\Backend
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class CommentController extends BaseController
{

    /**
     * @var CommentRepository
     */
    protected $comments;

    /**
     * @param CommentRepository $comments
     */
    public function __construct(CommentRepository $comments)
    {
        $this->comments = $comments;
    }

    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view($this->theme('comments.index'));
    }

    /**
     * @return \Illuminate\View\View
     */
    public function create()
    {
        // 
    }

    /**
     * @param StoreCommentRequest $request
     * @return mixed
     */
    public function store(StoreCommentRequest $request)
    {
        // 
    }

    /**
     * @param Comment $Comment
     * @param ManageCommentRequest $request
     * @return mixed
     */
    public function edit(Comment $Comment, ManageCommentRequest $request)
    {
        // return view('backend.Comments.edit')
            // ->withComment($Comment);
    }

    /**
     * @param UpdateCommentRequest $request
     * @return mixed
     */
    public function update(Comment $Comment, UpdateCommentRequest $request)
    {
        // $this->Comments->update($Comment, $request->all());
        // return redirect()->route('admin.Comment.index')->withFlashSuccess(trans('alerts.backend.general.updated',['attribute'=>'Comment']));
    }

    /**
     * @param Comment Comment
     * @param ManageCommentRequest $request
     * @return mixed
     */
    public function destroy(Comment $comment, ManageCommentRequest $request)
    {
        if($this->comments->delete($comment))
            return redirect()->route('admin.comments.index')->withFlashSuccess(trans('alerts.backend.general.deleted',['attribute' => 'Comment']));
    }

    /**
     * @param null
     * @return view
     */
    public function deleted()
    {
        $total_deleted_comments = $this->comments->getCount(true);
        return view($this->theme('comments.deleted'), compact('total_deleted_comments'));
    }

    /**
     * @param Comment $deletedComment
     * @param ManageCommentRequest $request
     * @return mixed
     */
    public function delete(Comment $deletedComment, ManageCommentRequest $request)
    {
        $this->comments->forceDelete($deletedComment);
        return redirect()->route('admin.comments.deleted')->withFlashSuccess(trans('alerts.backend.general.deleted_permanently',['attribute' => 'Comment']));
    }

    /**
     * @param ManageCommentRequest $request
     * @return mixed
     */
    public function emptyTrash(ManageCommentRequest $request)
    {
        $this->comments->emptyTrash();
        return redirect()->route('admin.comments.deleted')->withFlashSuccess(trans('alerts.backend.general.empty_trash',['attribute' => 'comment']));
    }

    /**
     * @param Comment $deletedComment
     * @param ManageCommentRequest $request
     * @return mixed
     */
    public function restore(Comment $deletedComment, ManageCommentRequest $request)
    {
        $this->comments->restore($deletedComment);
        return redirect()->route('admin.comments.index')->withFlashSuccess(trans('alerts.backend.general.restored',['attribute' => 'Comment']));
    }

    /**
     * @param Comment $comment
     * @param ManageCommentRequest $request
     * @return mixed
     */
    public function approve(Comment $comment, ManageCommentRequest $request)
    {
        $this->comments->status($comment, 1);
        return redirect()->route('admin.comments.index')->withFlashSuccess(trans('alerts.backend.general.restored',['attribute' => 'Comment']));
    }

    /**
     * @param Comment $comment
     * @param ManageCommentRequest $request
     * @return mixed
     */
    public function unapprove(Comment $comment, ManageCommentRequest $request)
    {
        $this->comments->status($comment, 0);
        return redirect()->route('admin.comments.index')->withFlashSuccess(trans('alerts.backend.general.restored',['attribute' => 'Comment']));
    }

    /**
     * @param ManageCommentRequest $request
     * @return mixed
     */
    public function getForDatatable(ManageCommentRequest $request)
    {
        return DataTables::of($this->comments->getForDataTable($request->get('trashed')))
            ->editColumn('created_at', function ($comment) {
                return $comment->created_at->diffForHumans();
            })
            ->editColumn('status', function ($comment) {
                return $comment->status == 1 ? '<span class="text-success">Approved</span>' : '<span class="text-danger">Not Approved</span>';
            })
            ->addColumn('actions', function($comment) {
                return $comment->action_buttons;
            })
            ->escapeColumns([])
            ->make(true);
    }
}