<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Access\User\Profile;
use App\Models\Category\Category;
use Illuminate\Http\Request;
use App\Models\Post\Post;
use App\Models\Tag\Tag;
use Illuminate\Support\Facades\Validator;

class FrontendController extends Controller
{
    public function posts(Request $request)
    {
        $orderBy = 'DESC';
        
        if($request->has('orderBy')) {
            $orderBy = $request->orderBy == 'ASC' ? 'ASC' : $orderBy;
        }
        if($request->has('category_id')) {
            $category = Category::find($request->category_id);
            $posts = $category->posts()->select('id','title','content','user_id','created_at')->where('type', 'post')->where('status', '1')->orderBy('id',$orderBy);
        }else{
            $posts = Post::select('id','title','content','user_id','created_at')->where('type', 'post')->where('status', '1')->orderBy('id',$orderBy);
        }
        if($request->has('limit') && is_numeric($request->limit)) {
            $posts = $posts->limit($request->limit);
        }
		if($request->has('offset') && is_numeric($request->offset)) {			
			$posts = $posts->skip($request->offset);
        }
        $data = [];
        $posts = $posts->get();
        $profiles = Profile::select('user_id','firstname','lastname','profile_picture')->get()->toArray();
        foreach($profiles as $profile) {
            $profiles[$profile->id] = [
                    'name' => $profile->firstname.' '.$profile->lastname,
                    'avatar' => ($profile->profile_picture != '') ? public_asset($profile->profile_picture) : public_asset('images/avatar.png')
                ];
        }
        foreach($posts as $post) {
            $data[] = [
                    'id' => $post->id,
                    'title' => $post->title,
                    'content' => $post->content(20),
                    'author' => isset($profiles[$post->user_id]) ? $profiles[$post->user_id] : [],
                    'post_date' => $post->created_at->format('M d, Y')
                ];
            
        }
        if($posts->isEmpty()) {
            return response()->json(['status' => false, 'message' => 'No posts available', 'data' => []]);
        }
        return response()->json(['status' => true, 'message' => 'List of posts', 'data' => $posts]);
    }

    public function post(Request $request)
    {
        $validator = Validator::make($request->all(), [
			'post_id' => 'required',
        ]);
        if ($validator->fails()) {
            $errors = $validator->messages()->all();
            return response()->json(['status' => false, 'message' => $errors[0], 'data' => []]);
		}
        $post = Post::where('id', $request->post_id)->where('status', '1')->first();
        if($post) {
            return response()->json(['status' => true, 'message' => 'Post data', 'data' => $post]);
        }
        return response()->json(['status' => false, 'message' => 'Post not available', 'data' => []]);
    }

    public function categories()
    {
        $categories = Category::select('id','title')->get();

        if($categories->isEmpty()) {
            return response()->json(['status' => false, 'message' => 'No categories available', 'data' => []]);
        }
        return response()->json(['status' => true, 'message' => 'List of categories', 'data' => $categories]);
    }

    public function tags()
    {
        $tags = Tag::select('id','title')->get();

        if($tags->isEmpty()) {
            return response()->json(['status' => false, 'message' => 'No tags available', 'data' => []]);
        }
        return response()->json(['status' => true, 'message' => 'List of tags', 'data' => $tags]);
    }
}
