<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\CategoryResource;
use App\Models\Category\Category;

class CategoryController extends Controller
{
    public function index()
    {
        $categories = Category::whereHas('posts', function ($q) {
            $q->where('type', 'product');
        })->get();

        return (CategoryResource::collection($categories))->response();
    }
}
