<?php

namespace App\Helpers;

use Illuminate\Support\Arr;
use Setting;

/**
 * Class Settings.
 *
 * @version 1.0.0
 *
 * @author Rawbinn Shrestha <contact@rawbinn.com>
 * @organization RAWBINN.COM.
 */
class Settings
{
    public static function get($key, $default = null)
    {
        $keys = explode('.', $key);
        $count = count($keys);
        $setting = Setting::get($keys[0]);

        $settings = json_decode($setting, true);
        if (is_array($settings)) {
            array_shift($keys);
            $skey = implode('.', $keys);

            return $count == 1 ? $settings : Arr::get($settings, $skey);
        }

        return $setting ?? $default;
    }

    /**
     * @return void
     */
    public static function update(array $settings): void
    {
        foreach ($settings as $key => $value) {
            if (is_array($value)) {
                $value = json_encode($value);
            }
            Setting::set($key, $value);
        }
    }
}
