<?php

namespace App\Exceptions;

use Illuminate\Database\QueryException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Session\TokenMismatchException;
use Illuminate\Validation\UnauthorizedException;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array
     */
    protected $dontReport = [
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array
     */
    protected $dontFlash = [
        'password',
        'password_confirmation',
    ];

    /**
     * Report or log an exception.
     *
     * @param \Exception $exception
     *
     * @return void
     *
     * @throws \Exception
     */
    public function report(Throwable $exception)
    {
        parent::report($exception);
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Exception               $exception
     *
     * @return \Symfony\Component\HttpFoundation\Response
     *
     * @throws \Exception
     */
    public function render($request, Throwable $exception)
    {
        // if ($exception instanceof QueryException) {
        //    if (strpos($exception->getMessage(), 'Access denied for user') !== false) {
        //         $path = base_path('.env');
        //         $env = file($path);
        //         $env = str_replace('INSTALLED=true', 'INSTALLED=false', $env);
        //         file_put_contents($path, $env);
        //         config(['access.INSTALLED' => false]);
                
        //         return redirect()->route('installer');
        //     }
        //     if (!config('access.INSTALLED')) {
        //         return redirect()->route('installer');
        //     }
        // } else {
            // if (strpos($exception->getMessage(), 'Base table or view not found') !== false) {
            //     $path = base_path('.env');
            //     $env = file($path);
            //     $env = str_replace('INSTALLED=true', 'INSTALLED=false', $env);
            //     file_put_contents($path, $env);
            //     config(['access.INSTALLED' => false]);
            //     return redirect()->route('installer');
            // } else
            if (strpos($exception->getMessage(), 'Unknown database') !== false) {
                // $path = base_path('.env');
                // $env = file($path);
                // $env = str_replace('INSTALLED=true', 'INSTALLED=false', $env);
                // file_put_contents($path, $env);
                // config(['access.INSTALLED' => false]);
                // return redirect()->route('installer');
            } 
            // if(!config('access.INSTALLED')) {
            //     return redirect()->route('installer');
            // }
        // }

        /*
         * Redirect if token mismatch error
         * Usually because user stayed on the same screen too long and their session expired
         */
        if ($exception instanceof TokenMismatchException) {
            return redirect()->to('login')->withFlashDanger('CSRF token mismatch.');;
        }
        if ($exception instanceof UnauthorizedException) {
            return redirect()
                ->route(home_route())
                ->withFlashDanger(__('auth.general_error'));
        }

        if ($exception instanceof GeneralException) {
            return redirect()->back()
                ->withFlashDanger($exception->getMessage());
        }

        // if(config('app.debug')){
        //     dd($exception->getMessage());
        // }
        if (strpos($exception->getMessage(), 'Permission denied') !== false) {
//            dd('Please provide read and write permission in storage and its child folder/files.');
        }

        return parent::render($request, $exception);
    }
}
