@extends('gear::layouts.master2')
@section('content')
    <div class="bread-crumb">
    	<div class="container">
    		<div class="row">
    			<div class="col-md-12 text-center">
    				<h1>{{ $page->title() }}</h1>
    				<a href="{{url('/')}}">Home</a> > {{ $page->title() }}
    			</div>
    		</div>
    	</div>
    </div>

<div class="content-page">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                @include('includes.partials.messages')
                <div class="product-feature-img">
                    @if($page->hasFeaturedImage())
               			 <img src="{{$page->featuredImage()}}" class="product-single-img" />
            		@endif
                </div>
                {!! $page->content() !!}
                <div class="post-metas">
                    @foreach($page->metas()->where('locale', app()->getLocale())->orderBy('post_meta.sort', 'ASC')->get() as $meta)
                    <div class="row post-meta-block {{$meta->key}}">
                        @foreach($meta->pull('post') as $key => $items)
                        <div class="col-md-{{$meta->pull('column', 12)}}">
                            @foreach($items as $item)
                                @if($item['type'] == 'title_block')
                                    <div class="post-meta-item title-block">
                                        <h2 style="text-align: {{$item['align'] ?? ''}};">{{ $item['title'] ?? ''}}</h2>
                                    </div>
                                @elseif($item['type'] == 'title_subtitle_block')
                                    <div class="post-meta-item title-subtitle-block">
                                        <h2 style="text-align: {{$item['align'] ?? ''}};">{{ $item['title'] ?? ''}}</h2>
                                        <h3 style="text-align: {{$item['align'] ?? ''}};">{{ $item['subtitle'] ?? ''}}</h3>
                                    </div>
                                @elseif($item['type'] == 'text_block')
                                    <div class="post-meta-item text-block">
                                        {!! $item['content'] !!}
                                    </div>
                                @elseif($item['type'] == 'text_block_title')
                                    <div class="post-meta text-block-with-title">
                                        <div class="post-meta-title">{{$item['title']}}</div>
                                        <div class="post-meta-body">
                                            {!! $item['content'] !!}
                                        </div>
                                    </div>
                                @elseif($item['type'] == 'text_block_title_image')
                                    <div class="row post-meta text-block-title-image">
                                        <div class="col-lg-7">
                                            <div class="post-meta-title">{{$item['title']}}</div>
                                            <div class="post-meta-body">
                                                {!! $item['content'] !!}
                                            </div>
                                        </div>
                                        <div class="col-lg-5">
                                            <img class="post-meta-image" src="{{image($item['featured_image'])}}">
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                        @endforeach
                    </div>
                    @endforeach
                </div>
            </div>


            <div class="col-lg-4">
                <div class="book-button">
                    <a href="https://booking.ritubeautyparlour.com/" class="book-service-btn" target="_blank">Book Service Now</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection